#!/usr/bin/env python3
# Copyright (c) 2017-present The Bitcoin Core developers
# Distributed under the MIT software license, see the accompanying
# file COPYING or http://www.opensource.org/licenses/mit-license.php.
"""Test the RPC call related to the uptime command.

Test corresponds to code in rpc/server.cpp.
"""

import time

from test_framework.test_framework import BitcoinTestFramework
from test_framework.util import assert_raises_rpc_error


class UptimeTest(BitcoinTestFramework):
    def set_test_params(self):
        self.num_nodes = 1
        self.setup_clean_chain = True

    def run_test(self):
        self._test_negative_time()
        self._test_uptime()

    def _test_negative_time(self):
        assert_raises_rpc_error(-8, "Mocktime must be in the range [0, 9223372036], not -1.", self.nodes[0].setmocktime, -1)

    def _test_uptime(self):
        time.sleep(1) # Do some work before checking uptime
        uptime_before = self.nodes[0].uptime()
        assert uptime_before > 0, "uptime should begin at app start"

        wait_time = 20_000
        self.nodes[0].setmocktime(int(time.time()) + wait_time)
        uptime_after = self.nodes[0].uptime()
        self.nodes[0].setmocktime(0)
        assert uptime_after - uptime_before < wait_time, "uptime should not jump with wall clock"


if __name__ == '__main__':
    UptimeTest(__file__).main()
